 aR  w / m^9      h	 oP      nSystem-wide$NOLIST

        NAME  MsConsole

;  This module contains routines that are very close to GRiD-OS calls, but
;  are implemented by calling MsDos directly.

;  Thanks goes to Peggy Seltz who originally wrote these routines!

CGROUP GROUP CODE

PUBLIC  MsKeyPressed, MsCharIn
PUBLIC  MsHexOut, MsLineOut, MsCharOut
PUBLIC  MsMoveCsr

; EQUATES

BellChar	         EQU  7	;bell
BS		         EQU  08H	;backspace
CR		         EQU  0DH	;carriage return
LF		         EQU  0AH	;line feed
TRUEBit	         EQU  1	;Boolean true value
FALSEBit	         EQU  0	;Boolean false value

NormalAttribute   EQU  7
MaxColNumber      EQU 79
PcLastRow         EQU 25

CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP
$EJECT

;*****************************************************************************
;
;  MsKeyPressed: PROCEDURE BOOLEAN CLEAN;
;
;    Returns TRUE if a key is in the keyboard buffer, otherwise returns FALSE.
;
;*****************************************************************************

MsKeyPressed PROC NEAR
	MOV  AH, 0BH
	INT  21H
	RET
MsKeyPressed ENDP


;*****************************************************************************
;
;  MsCharIn: PROCEDURE BYTE CLEAN;
;
;    Waits for a key to be pressed and returns that key to the caller.
;
;*****************************************************************************

MsCharIn PROC NEAR
    MOV  AH, 07H	; Cntl-C Interrupt Check Disabled
    INT  21H
    RET
MsCharIn ENDP
$EJECT

;*****************************************************************************
;
; MsHexOut: PROCEDURE (num) CLEAN;
;	DCL num WORD; {number to be converted to character and output}
;
;	Outputs the hexadecimal number specified by num to the current cursor
;	position.
;
;*****************************************************************************

num	EQU	WORD PTR [BP+4]

MsHexOut PROC NEAR
	PUSH	BP
	MOV	BP, SP

	MOV	AX, num
	MOV	BX, AX	;another copy of hex number
	MOV	CL, 4
	SHR	AL, CL	;high 4 bits
	SHR	AH, CL	;high 4 bits
	AND	BX, 0F0FH	;low 4 bits

	CALL	HexToChar	;internal routine, byte to convert in AH
	XCHG	AH, BH
	CALL	HexToChar	;internal routine, byte to convert in AH
	XCHG	AH, AL
	CALL	HexToChar	;internal routine, byte to convert in AH
	XCHG	AH, BL
	CALL	HexToChar	;internal routine, byte to convert in AH
	MOV	CL, AH	;last of four bytes
	PUSH	CX	;pass byte to output
	PUSH	BX	;pass third byte to output
	PUSH	AX	;pass second byte to output
	MOV	CL, BH	;first byte to output
	PUSH	CX	;pass first byte to output
	CALL	MsCharOut	;output first byte
	CALL	MsCharOut	;output second byte
	CALL	MsCharOut	;output third byte
	CALL	MsCharOut	;output fourth byte
		
	POP	BP
	RET	2
MsHexOut ENDP

PURGE num
$EJECT

;*****************************************************************************
;
; HexToChar: PROCEDURE;
;
;	INPUT: AH contains the 4 bits that are to be converted to a hex char.
;
;	Converts hex 4 bits in AH to a character.
;
;*****************************************************************************

HexToChar PROC NEAR
	CMP	AH, 9	;convert to characters '0' to '9'
	JBE	HexToChar1	;hex number '0'-'9'

	ADD	AH, 37H	;convert to hex number 'A'-'F'
	RET

HexToChar1:
	ADD	AH, 30H	;convert hex to character '0' to '9'
	RET
HexToChar ENDP
$EJECT

;*****************************************************************************
;
; MsLineOut: PROCEDURE (pStr, len) CLEAN;
;	DCL pStr POINTER; {pointer to buffer}
;	DCL len  WORD;    {len of buffer    }
;
;	Outputs the number of characters specified by length to the window.
;
;*****************************************************************************

pStr	EQU DWORD PTR [BP+6]
len		EQU  WORD PTR [BP+4]

MsLineOut PROC NEAR
	PUSH	BP
	MOV	BP, SP

	MOV	CX, len	;count = length of string
	JCXZ	MsLineOutExit	;check if count is zero

	LES	BX, pStr	;load buffer pointer

MsLineOutLoop:
	PUSH	CX	;save count
	PUSH	ES	;save buffer pointer segment
	PUSH	BX	;save buffer pointer offset
	MOV	AL, ES:[BX]	;character to output
	PUSH	AX	;pass character
	CALL	MsCharOut	;output character
	POP	BX	;restore buffer pointer offset
	INC	BX	;update buffer pointer
	POP	ES	;restore buffer pointer segment
	POP	CX	;restore count
	LOOP	MsLineOutLoop	;write next character

MsLineOutExit:
	POP	BP
	RET	6
MsLineOut ENDP

PURGE pStr, len
$EJECT

;*****************************************************************************
;
; MsCharOut: PROCEDURE (char) CLEAN;
;	DCL char BYTE;
;
;	Outputs the supplied character to the screen at the current cursor
;	position.  Special operations are performed if the character is a
;	carriage return, line feed, bell char or backspace. If outputing the
;	character should result in the screen scrolling the procedure  does this
;	by calling ScrollScreen. Characters output to the display are output
;	with both character and attribute.
;
;*****************************************************************************

char EQU BYTE PTR [BP+4]

MsCharOut PROC NEAR
	PUSH	BP
	MOV	BP, SP

	CALL	GetCursorPos
	MOV	AL, char	;character to be output
	CMP	AL, BS	;backspace character?
	JNE	CheckForCr	;no go check for carriage return    

	OR	DL, DL	;is column already zero ?
	JZ	BackSpace2	;jump if already zero
	DEC	DL	;decrement the column

BackSpace2:
	CALL	SetCursorPos	;go position cursor
	JMP	SHORT MsCharOutExit
	
CheckForCr:
	CMP	AL, CR	;is it a carriage return
	JNE	CheckForLf	;no - go check for line feed

	XOR	DL, DL	;set to column 1
	CALL	SetCursorPos	;go position cursor
	JMP	SHORT MsCharOutExit

CheckForLf:
	CMP	AL, LF	;is it a carriage return
	JNE	CheckForBell	;no - go check for line feed

CheckForLf2:
	INC	DH	;increment to next line
	CMP	DH, PcLastRow	;is it at last line ?
	JB	LineFeed2	;no - skip increment scroll

	DEC	DH
	PUSH	DX
	CALL	ScrollScreen	;scroll the screen
	POP	DX

LineFeed2:
	CALL	SetCursorPos	;go set the cursor
	JMP	SHORT MsCharOutExit

CheckForBell:
	CMP	AL, bellChar	;is it a bell character ?
	JNE	SendOutChar	;no - go send out char

	MOV	BX, 7	;set default attribute on page zero
	MOV	AH, 14	;set for output
	CALL	VideoIO	;output bell character
	JMP	SHORT MsCharOutExit

SendOutChar:
	PUSH	DX
	MOV	CX, 1	;set the character count
	XOR	BH, BH	;set page
	MOV	BL, NormalAttribute	;set the current attribute
	MOV	AH, 9	;set to output char and attribute
	CALL	VideoIO	;output character
	
	POP	DX	;retrieve cursor position
	CMP	DL, MaxColNumber	;is cursor at end?
	JE	SendOutChar2
	
	INC	DL	;increment to next position
	CALL	SetCursorPos	;go move the cursor
	JMP	SHORT MsCharOutExit

SendOutChar2:
	XOR	DL, DL	;set to column 1
	JMP	SHORT CheckForLf2	;go position cursor

MsCharOutExit:
	POP	BP
	RET	2
MsCharOut ENDP

PURGE char
$EJECT

;*****************************************************************************
;
; MsResetDisplay: PROCEDURE CLEAN;
;
;	Clears the screen and moves the cursor to the top left hand of the screen.
;   (This routine no longer attempts to change the cursor)
;
;*****************************************************************************

MsResetDisplay PROC NEAR
	MOV	AX, 600H	;blank window
	MOV	BH, 7	;default attribute
	XOR	CX, CX
	MOV	DL, MaxColNumber
	MOV	DH, PcLastRow
	CALL	VideoIO
	MOV	AL, 0
	PUSH	AX
	PUSH	AX
	CALL	MsMoveCsr
	RET
MsResetDisplay ENDP
$EJECT

;*****************************************************************************
;
; MsMoveCsr: PROCEDURE (x, y) CLEAN;
;	DCL (x,y) BYTE; {char col and row pos where cursor is to be positioned}
;
;	Repositions the current cursor loc to the specified character	position
;
;	This is different than Peggy's routine: x and y are zero relative
;
;*****************************************************************************

x	EQU	BYTE PTR [BP+6]
y	EQU	BYTE PTR [BP+4]

MsMoveCsr PROC NEAR
	PUSH	BP
	MOV	BP, SP

	MOV	DL, x	;column position + 1
	MOV	DH, y	;row position + 1
	XOR	BH, BH	;page zero
	MOV	AH, 2	;set cursor position function
	CALL	VideoIO	;set cursor position
	
	POP	BP
	RET	4
MsMoveCsr ENDP

PURGE x, y
$EJECT

;*****************************************************************************
;
;  ScrollScreen: PROCEDURE;
;
;	This procedure scrolls the display using the scroll window funcion of the
;	ROM BIOS.
;
;*****************************************************************************

ScrollScreen PROC NEAR
	MOV	AL, 1	;scroll count
	MOV	AH, 6	;set to scroll window
	MOV	BH, NormalAttribute	;current character attribute
	XOR	CX, CX	;set scroll start point
	MOV	DL, MaxColNumber	;lower right x value
	MOV	DH, PcLastRow	;lower right y value + 1
	DEC	DH	;y value
	CALL	VideoIO	;scroll the screen
	RET
ScrollScreen ENDP
$EJECT

;*****************************************************************************
;
; GetCursorPos:  PROCEDURE;
;
;	EXIT:
;		DL = column number
;		DH = row number
;
;	Gets the current cursor row and column cooridinates
;
;******************************************************************************

GetCursorPos PROC NEAR
	XOR	BH, BH	;page
	MOV	AH, 3	;set to get cursor position
	CALL	VideoIO	;go get position
	RET
GetCursorPos ENDP


;*****************************************************************************
;
;  SetCursorPos: PROCEDURE;
;
;	INPUT: DH = row number where cursor to be placed (0-79)
;		  DL = column number where cursor is to be placed (0-24)
;
;	This procedure moves the cursor to the requested position. If the
;	parameters are out of range they will be replaced with the limit value.
;
;******************************************************************************

SetCursorPos PROC NEAR
	XOR	BH, BH	;page
	MOV	AH, 2	;get set to position
	CALL	VideoIO	;set the cursor position
	RET
SetCursorPos ENDP
$EJECT

;*****************************************************************************
;
; VideoIO: PROCEDURE;
;
;	Saves the BP register and calls the Video I/O interrupt.
;
;*****************************************************************************

VideoIO PROC NEAR
	PUSH	BP	;save register
	INT	10H	;video I/O, destroys BP
	POP	BP	;restore register
	RET
VideoIO ENDP


CODE    ENDS

        END
